﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCEVENTREMINSTRUMENT")]


public partial class ucEventRemoveInstrument : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    /// <summary>
    /// US:7357 patient pathway event id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCEVTREMINTSR_PATPWEVENTID"] != null)
            {
                strValue = Session["UCEVTREMINTSR_PATPWEVENTID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEVTREMINTSR_PATPWEVENTID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7357 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {

    }


    /// <summary>
    /// US:7357 show the intrument remove popup
    /// </summary>
    public void Show()
    {
        //clear the instruments
        gpEventRemInstruments.GetStore().RemoveAll();
        storEventRemInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get event info
        CCPA cpa = new CCPA();
        
        //get all modules already added to this event
        DataSet dsMID = cpa.GetPWEventModuleDS(BaseMstr, CDataUtils2.ToLong(PatPWEventID));

        foreach (DataTable table in dsMID.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
                //module data is not encoded in the db...
                row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
            }
        }
        dsMID.AcceptChanges();

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storEventRemInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));
               
        //show the window
        wndEventRemInstrument.Show();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7357 ok button handler for instrument remove popup
    /// </summary>
    protected void OnInstrSelRemOK(object sender, DirectEventArgs e)
    {
        //JSON representation
        string gpJSON = e.ExtraParams["gpSelParam"];

        //XML representation
        XmlNode gpXml = JSON.DeserializeXmlNode("{records:{record:" + gpJSON + "}}");

        //array of Dictionaries
        Dictionary<string, string>[] gpData = JSON.Deserialize<Dictionary<string, string>[]>(gpJSON);

        //all selected modules much have module for set
        string strMIDS = ",";
        for (int i = 0; i < gpData.Count(); i++)
        {
            if (!String.IsNullOrEmpty(gpData[i]["MID"]))
            {
                strMIDS += gpData[i]["MID"] + ",";
            }
        }

        CCPA cpa = new CCPA();
        bool bStatus = cpa.DeletePWEventModules(BaseMstr, BaseMstr.SelectedPatientID, CDataUtils2.ToLong(PatPWEventID), strMIDS);
        if (!bStatus)
        {
            BaseMstr.ShowSystemFeedback("Error removing instruments, please contact your system administrator!", "Error");
            return;
        }

        wndEventRemInstrument.Hide();
    }

}